pico-8 cartridge // http://www.pico-8.com
version 32
__lua__
--vars
function _init()
		part={}
		parts=true
		cartdata("possiblyaxolotl_beancompletion")
		lastlevel = 0
		pos="front"
		fadedir = -2
		fadepos = 20
		currentlevel = 0
		num=0
		loops=0
		val="warp to area"
		bgclr = 2
		startclr=1
  player={
    sp=1,
    x=59,
    y=59,
    w=8,
    h=8,
    flp=false,
    dx=0,
    dy=0,
    max_dx=2,
    max_dy=3,
    acc=0.5,
    boost=4,
    anim=0,
    running=false,
    jumping=false,
    falling=false,
    sliding=false,
    landed=false
  }
		
  gravity=0.3
  friction=0.85

  --simple camera
  cam_x=0
		cam_y=128
		
  --map limits
  map_start=0
  map_end=1024
  r_edge = 128
  
  lvlup(currentlevel)
end

function main()
	load("beanmenu.p8")
end

menuitem(4,"⌂exit to menu⌂",main)
menuitem(5,"----------")
-->8
--update and draw

--cam_y=128 brings the cam
--down to lvl2

function playupdate()

		if parts == true then
			updateparts()
		end
		
  player_update()
  player_animate()

  --simple camera
  cam_x=player.x-64+(player.w/2)
  if cam_x<map_start then
     cam_x=map_start
  end
  if cam_x>map_end-r_edge then
     cam_x=map_end-r_edge
  end
  
  cam_y=player.y-64+(player.w/2)
  if cam_y<map_top then
     cam_y=map_top
  end
  if cam_y>map_top-map_bottom then
     cam_y=map_top-map_bottom
  end
  camera(cam_x,cam_y)
end

function playdraw()
  cls(bgclr)
  if pos == "front" then
  	map(0,0)
  if nu == 1 then
  	drawparts()
  end
  	spr(player.sp,player.x,player.y,1,1,player.flp)
  elseif pos == "back" then
  	spr(player.sp,player.x,player.y,1,1,player.flp)
			map(0,0)
		end
		fade()
		spr(16,map_start+1,cam_y,7,2)
  print(((time()-start)),map_start+3,cam_y+3,1)
end

function menudraw()
	cls()
	spr(12,48,44,4,4)
	print("press [enter] to pause",20,78,startclr)
	print("press ❎/🅾️ to start",24,88,startclr)
	fade()
end

function menuupdate()
	startgame()
	if btnp(❎) or btnp(🅾️) then
		start=true
		sfx(0)
	end
end

function startgame()
	val ="warp"
	if startclr == 12 then
		menuitem(3,"⬅️ effects "..va.." ➡️",incdec2)
		menuitem(1,"⬅️ warp ➡️", incdec)
		menuitem(2,"warp to selected", warpto)
		_draw=playdraw
		_update=playupdate
		start = time()
	elseif start == true then
			startclr+=1
			fadedir = 1
	end
end

_draw = menudraw
_update = menuupdate

function incdec(b)
 if (b&1 > 0) num-=1
 if (b&2 > 0) num+=1
 
 if num == 1 then val = "1: jungle"end
 if num == 2 then val = "2: snow"end
 if num == 3 then val = "lvl pack 1"end
 if num == 4 then val = "1: jungle" num = 1end
 if num <= 0 then val = "lvl pack 1" num = 3end
 if num == 5 then val = "1: jungle" num = 1end
 
 menuitem(1,"⬅️ "..val.." ➡️",incdec)

 return true
end

function warpto()
	if val == "1: jungle" then
		currentlevel=0
		lvlup(0)
	end
	
	if val == "2: snow" then
		currentlevel=8
		lvlup(8)
	end

	if val == "lvl pack 1" then
		currentlevel=17
		lvlup(17)
	end
end

va = "on"
nu = 1
function incdec2(b)
 if (b&1 > 0) nu-=1
 if (b&2 > 0) nu+=1
 
 if nu <= 0 then va = "off" nu = 2end
 if nu == 1 then va = "on"end
 if nu == 2 then va = "off"end
 if nu >= 3 then va = "on" nu = 1end

 menuitem(3,"⬅️ effects "..va.." ➡️",incdec2)

 return true
end
-->8
--collisions

function collide_map(obj,aim,flag)
 --obj = table needs x,y,w,h
 --aim = left,right,up,down

 local x=obj.x  local y=obj.y
 local w=obj.w  local h=obj.h

 local x1=0	 local y1=0
 local x2=0  local y2=0

 if aim=="left" then
   x1=x-1  y1=y
   x2=x    y2=y+h-1

 elseif aim=="right" then
   x1=x+w-1    y1=y
   x2=x+w  y2=y+h-1

 elseif aim=="up" then
   x1=x+2    y1=y-1
   x2=x+w-3  y2=y

 elseif aim=="down" then
   x1=x+2      y1=y+h
   x2=x+w-3    y2=y+h
 end

 --pixels to tiles
 x1/=8    y1/=8
 x2/=8    y2/=8
	
 if fget(mget(x1,y1), flag)
 or fget(mget(x1,y2), flag)
 or fget(mget(x2,y1), flag)
 or fget(mget(x2,y2), flag) then
   return true
 else
   return false
 end

end
-->8
--player

function player_update()

		--level up
		if fadepos == 0 and collide_map(player,"down",7) or collide_map(player,"right",7) or collide_map(player,"down",7) then
			currentlevel+=1
			if va == "on" then
				fadedir=2
			else lvlup(currentlevel) end
		end
		--death
  if collide_map(player,"down",2) then
			spawnexplosion(player.x+4,player.y+4)
			lvlup(currentlevel)
  end
  
  --check for bouncr
  if collide_map(player,"down",3) then
			sfx(1)
			spawnpillpuft(player.x+4,player.y+4,2)
			player.dy = -6
		end

 --check for bouncr
  if collide_map(player,"up",6) then
			load("beanmenu")
		end
		
  
  if collide_map(player,"down",4) then
  	gravity = 0.1
  	player.max_dy=1
  else
  	gravity = 0.3
  	player.max_dy=3
  end
		
  --physics
  player.dy+=gravity
  player.dx*=friction

  --controls
  if btn(⬅️) then
    player.dx-=player.acc
    player.running=true
    player.flp=true
  end
  
  if btn(➡️) then
    player.dx+=player.acc
    player.running=true
    player.flp=false
  end

  --slide
  if player.running
  and not btn(⬅️)
  and not btn(➡️)
  and not player.falling
  and not player.jumping then
    player.running=false
    player.sliding=true
  end

  --jump
  if player.landed then
				spawnpuft(player.x+4,player.y+4)
    player.dy-=player.boost
    player.landed=false
  end

  --check collision up and down
  if player.dy>0 then
    player.falling=true
    player.landed=false
    player.jumping=false

    player.dy=limit_speed(player.dy,player.max_dy)

    if collide_map(player,"down",0) then
      player.landed=true
      player.falling=false
      player.dy=0
      player.y-=((player.y+player.h+1)%8)-1
    end
  elseif player.dy<0 then
    player.jumping=true
    if collide_map(player,"up",1) then
      player.dy=0
    end
  end

  --check collision left and right
  if player.dx<0 then

    player.dx=limit_speed(player.dx,player.max_dx)

    if collide_map(player,"left",1) then
      player.dx=0
    end
    if collide_map(player,"left",5) then
      player.dx=3
      player.dy = -3
					spawnpuft(player.x+4,player.y+4)
    end
  elseif player.dx>0 then

    player.dx=limit_speed(player.dx,player.max_dx)

    if collide_map(player,"right",1) then
      player.dx=0
    end
    if collide_map(player,"right",5) then
      player.dx=-3
      player.dy = -3
						spawnpuft(player.x+4,player.y+4)
    end
  end

  --stop sliding
  if player.sliding then
    if abs(player.dx)<.2
    or player.running then
      player.dx=0
      player.sliding=false
    end
  end

  player.x+=player.dx
  player.y+=player.dy

  --limit player to map
  if player.x<map_start then
    player.x=map_start
  end
  if player.x>map_end-player.w then
    player.x=map_end-player.w
  end
end

function player_animate()
	if player.dy < 0 then player.sp = 2
	elseif player.dy > 0 then player.sp = 3
	else player.sp = 1 end 
end

function limit_speed(num,maximum)
  return mid(-maximum,num,maximum)
end
-->8
--level up
function lvlup(level)
	player.dx = 0
	player.dy = 0
	map_top = 0
	bgclr=13
	map_bottom = 0
	if level != 0 and lastlevel < currentlevel then
		map_start += 128
		r_edge-=128
	end
	
	lastlevel = currentlevel
	
	player.dy = 0
	if level == 0 then
		player.x = 16
		player.y = 80
		r_edge = 1024
		map_start = 0
		cam_x = 0
		cam_y = 0
	end
		
	if level == 1 then
		player.x = 144
		player.y = 104
	end
	
	if level == 2 then
		player.x = 280
		player.y = 112
	end
	
	if level == 3 then
		player.x = 440
		player.y = 100
	end

	if level == 4 then
		player.x = 65*8
		player.y = 13*8
	end
	
	if level == 5 then
		player.x = 650
		player.y = 90
	end

	if level == 6 then
		player.x = 97*8
		player.y = 11*8
		r_edge=128
	end

	if level == 7 then
		level = 8
		lvlup(8)
	end
	
	if level >= 8 and level <= 15 then
		map_top = 128
		bgclr = 13
		cam_x = 0
		cam_y = 128
	end

	if level == 8 then
		player.x = 16
		player.y = 208
		r_edge = 1024
		map_start = 0
	end

	if level == 9 then
		player.x = 144
		player.y = 144
	end

	if level == 10 then
		player.x = 264
		player.y = 216
	end

	if level == 11 then
		player.x = 488
		player.y = 160
	end

	if level == 12 then
		player.x = 568
		player.y = 236
	end

	if level == 13 then
		player.x = 648
		player.y = 208
	end

	if level == 14 then
		player.x = 776
		player.y = 200
	end

	if level == 15 then
		player.x = 904
		player.y = 208
	end

	if level == 16 then
		dset(1,1)
	end

	if level == 17 then
	load("bean1.p8")
	end
end
-->8
function fade()
--add vars fadedir and fadepos
--constantly run fade
--fadedir -1 fade in 1 fade out
local fade,c,p={[0]=0,17,18,19,20,16,22,6,24,25,9,27,28,29,29,31,0,0,16,17,16,16,5,0,2,4,0,3,1,18,2,4}
  pal()
  for i=0,fadepos do
    if i%2==1 then
      for j=0,15 do
        c=peek(24336+j)
        if (c>=128) c-=112
        p=fade[c]
        if (p>=16) p+=112
        pal(j,p,1)
      end
    end
  end
  fadepos+=fadedir
  if fadedir > 0 then player.x = 256 player.y = 256 end
  if (fadepos<0) fadedir=0 fadepos=0
  if (fadepos>21) fadedir=-2 fadepos=21
		if fadedir < 0 then lvlup(currentlevel) end
end     

function addpart(_x,_y,_dx,_dy,_type,_maxage,_col,_s)
 local _p = {}
 _p.x=_x
 _p.y=_y
 _p.dx=_dx
 _p.dy=_dy
 _p.tpe=_type 
 _p.mage=_maxage
 _p.age=0
 _p.col=0
 _p.colarr=_col
 _p.rot=0
 _p.rottimer=0
 _p.s=_s
 _p.os=_s
 
 add(part,_p)
end
 
-- spawn a small puft
function spawnpuft(_x,_y)
 for i= 0,5 do
  local _ang = rnd()
  local _dx = sin(_ang)*1
  local _dy = cos(_ang)*1
  addpart(_x,_y,_dx,_dy,2,15+rnd(15),{7,6,5},1+rnd(2))
 end
end
 
-- spawn a puft in the color of a pill
function spawnpillpuft(_x,_y,_p)
 for i= 0,20 do
  local _ang = rnd()
  local _dx = sin(_ang)*(1+rnd(2))
  local _dy = cos(_ang)*(1+rnd(2))
  local _mycol
  
  if _p == 1 then
   -- slowdown -- orange
   _mycol={9,9,4,4,0}
  elseif _p == 2 then
   -- life -- white
   _mycol={7,7,6,5,0}
  elseif _p == 3 then
   -- catch -- green
   _mycol={11,11,3,3,0}
  elseif _p == 4 then
   -- expand -- blue
   _mycol={12,12,5,5,0}
  elseif _p == 5 then
   -- reduce -- black
   _mycol={0,0,5,5,6}
  elseif _p == 6 then
   -- megaball -- pink
   _mycol={14,14,13,2,0}
  else
   -- multiball -- red
   _mycol={8,8,4,2,0}
  end  
  addpart(_x,_y,_dx,_dy,2,20+rnd(15),_mycol,1+rnd(4))
 end
end
 
-- spawn death particles
function spawndeath(_x,_y)
 for i= 0,30 do
  local _ang = rnd()
  local _dx = sin(_ang)*(2+rnd(4))
  local _dy = cos(_ang)*(2+rnd(4))
  local _mycol
  
  _mycol={8,8,2,0}
  addpart(_x,_y,_dx,_dy,2,80+rnd(15),_mycol,3+rnd(6))
 end
end
 
-- spawn death particles
function spawnexplosion(_x,_y)
 --first smoke
 sfx(14)
 for i= 0,20 do
  local _ang = rnd()
  local _dx = sin(_ang)*(rnd(4))
  local _dy = cos(_ang)*(rnd(4))
  local _mycol
  _mycol={0,0,5,5,6}
  addpart(_x,_y,_dx,_dy,2,80+rnd(15),_mycol,3+rnd(6))
 end
 --fireball
 for i= 0,30 do
  local _ang = rnd()
  local _dx = sin(_ang)*(1+rnd(4))
  local _dy = cos(_ang)*(1+rnd(4))
  local _mycol
  _mycol={7,10,9,8,5}
  addpart(_x,_y,_dx,_dy,2,30+rnd(15),_mycol,2+rnd(4))
 end
 
end
 
-- spawn a trail particle
function spawntrail(_x,_y)
 if rnd()<0.5 then
  local _ang = rnd()
  local _ox = sin(_ang)*4*0.3
  local _oy = cos(_ang)*4*0.3
 
  addpart(_x+_ox,_y+_oy,0,0,0,15+rnd(15),{5,6},0)
 end
end
 
-- spawn a megatrail particle
function spawnmtrail(_x,_y)
 if rnd() then
  local _ang = rnd()
  local _ox = sin(_ang)*2
  local _oy = cos(_ang)*2
 
  addpart(_x+_ox,_y+_oy,0,0,2,20+rnd(15),{14,8,2},1+rnd(1))
 end
end

function updateparts()
 local _p
 for i=#part,1,-1 do
  _p=part[i]
  _p.age+=1
  if _p.age>_p.mage then
   del(part,part[i]) 
  else
   -- change colors
   if #_p.colarr==1 then
    _p.col = _p.colarr[1]
   else
    local _ci=_p.age/_p.mage
    _ci=1+flr(_ci*#_p.colarr)
    _p.col = _p.colarr[_ci]
   end
   
   --appy gravity
   if _p.tpe == 1 or _p.tpe == 3 then
    _p.dy+=0.05
   end
   
   --rotate
   if _p.tpe == 3 then
    _p.rottimer+=1
    if _p.rottimer>5 then
     _p.rot+=1
     if _p.rot>=4 then
      _p.rot=0
     end
    end
   end
   
   --shrink
   if _p.tpe == 2 then
    local _ci=1-(_p.age/_p.mage)
    _p.s=_ci*_p.os
   end
   
   --friction
   if _p.tpe == 2 then
             _p.dx=_p.dx/1.2
             _p.dy=_p.dy/1.2
   end
   
   --move particle
   _p.x+=_p.dx
   _p.y+=_p.dy
  end
 end  
end
 
-- big particle drawer
function drawparts()
 for i=1,#part do
  _p=part[i]
  -- pixel particle
  if _p.tpe == 0 or _p.tpe == 1 then
   pset(_p.x,_p.y,_p.col)
  elseif _p.tpe == 2 then
   circfill(_p.x,_p.y,_p.s,_p.col)
  elseif _p.tpe == 3 then
   local _fx,_fy
   if _p.rot==2 then
    _fx=false
    _fy=true
   elseif _p.rot==3 then
    _fx=true
    _fy=true
   elseif _p.rot==4 then
    _fx=true
    _fy=false
   else
    _fx=false
    _fy=false
   end
   
   spr(_p.col,_p.x,_p.y,1,1,_fx,_fy)
  end
 end  
end
__gfx__
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000077777000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000070000700000000000000000000000000
00700700000000000000000000000000000000000000000000000000000000000000000000000000000000000000000070000700000777700000000000000000
00077000022222200222222002222220000000000000000000000000000000000000000000000000000000000000000077777777007000070077777007777000
00077000288888822878878228888882000000000000000000000000000000000000000000000000000000000000000070000000707000070700007070000700
00700700287887822888888228888882000000000000000000000000000000000000000000000000000000000000000070000000707777700700007070000700
00000000288888822888888228788782000000000000000000000000000000000000000000000000000000000000000070000000707000000700077070000700
00000000022222200222222002222220000000000000000000000000000000000000000000000000000000000000000077777777000777770077707070000700
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
011111111111111111111111111111111111111111111110000000000000000000000000000000000000000000000000222e0022e02e02e022e0022e222e0000
1666666666666666666666666666666666666666666666610011111000000000000000000000000000000000000000002e02e2222e2e02e2222e222e2e000000
1666666666666666666666666666666666666666666666610116661100000000000000000000000000000000000000002e02e2e02e2e02e2e02e2e00222e02e0
166666666666666666666666666666666666666666666661016616610000000000000000000000000000000000000000222e02e02e2e02e2e02e2e002e00222e
1666666666666666666666666666666666666666666666610166116100000000000000000000000000000000000000002e02e2222e2222e2e02e222e2e0002e0
1666666666666666666666666666666666666666666666610166666100000000000000000000000000000000000000002222e022e0022e02e02e022e222e0000
16666666666666666666666666666666666666666666666101166611000000000000000000000000000000000000000000000000000000000000000000000000
16666666666666666666666666666666666666666666666100111110000000000000000000000000000000000000000000000000000000009999999999999999
01111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000009999999999999999
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000222222000000a9a9a99aa9a9a99a
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000287887820000039ba7aab39ba7aab
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000028888882000003abb73bb3abb73bb
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000288888820000033bbb3bb33bbb3bb
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002222220000003333333b3333333b
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000003333333333333333
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000007077070000003bbbb7773bbbb777
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000070770700000033bbbbb733bbbbb7
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000707007000000333333b7333333b7
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000007070700707000033b773bb33b773bb
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000700770070000033bb73bb33bb73bb
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000999999999999999933bbb3bb33bbb3bb
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000099999999999999993333333b3333333b
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000a9a9a99aa9a9a99a3333333333333333
3bbbb7779999999956666777dddddddd999999960000000000300b303bbbb7773bbbb77700000000000000000000000000000000000000000000000000000000
33bbbbb79999999955666667dddddddd999996670000000000300bb033bbbbb003bbbbb700000000000000000000000000000000000000000000000000000000
333333b7a9a9a99a55555567cdcdcddca9a960770000000000bb003033333300003333b700000000000000000000000000000000000000000000000000000000
33b773bb39ba7aab556775665d6c7cc639ba600700000000030b033033b77000000773bb00000000000000000000000000000000000000000000000000000000
33bb73bb3abb73bb556675665c6675663abb600700000000bb00030033bb0000000073bb00000000000000000000000000000000000000000000000000000000
33bbb3bb33bbb3bb556665665566656633b60707000000000b30033033b00000000003bb00000000000000000000000000000000000000000000000000000000
3333333b3333333b5555555655555556336000770000000000300030330000000000003b00000000000000000000000000000000000000000000000000000000
33333333333333335555555555555555367777770000000000300030300000000000000300000000000000000000000000000000000000000000000000000000
00444444444444444444440000700000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
04999999999999999999774000700000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
49994444444444444444977400700000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
49994444444444444444999400700000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
04999999999999999999994000888800000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00444444444444444444440000888000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000780000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00700070000770000000007766666667770000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00070007000670000000777666666677677700000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
70007000006677000077766606666670666777000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
07000700006667007776666606666770666667770000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00700070066667707666666600666700666666670000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00070007066666700066666600667700666666000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
70007000666666770000666600067000666600000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
07000700666666670000006600077000660000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
08888880000000000000000011111111777777770000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
8888888e010101010000870011111111770007070000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
8888888e000000000008880011111111707000770000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
888eeeee101010100088880011111111700700070000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
01111110010101010000070011111111700070070000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
1dddddd1111111110000070011111111770007070000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
01111110111111110000070011111111707000770000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
1dddddd1111111110000070011111111777777770000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
3333333b0333333b333333b0033333b033b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
3333333b3333333b3333333b3333333b33b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
33b0000033b0000033b0033b333b333b33b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
3333333b33b000003333333b33b0033b33b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
3333333b33b00000333333b033b0033b33b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000033b33b0000033b033b0333b333b33b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
3333333b3333333b33b0333b3333333b3333333b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
3333333b0333333b33b0033b033333b03333333b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00111100001111000111111001111110010010100011110000000000000000000000000000000000000000000000000000000000000000000000000000000000
01000010010000100100000000010000010010100100001000000000000000000000000000000000000000000000000000000000000000000000000000000000
01000010010000100111000000010000010010100100001000000000000000000000000000000000000000000000000000000000000000000000000000000000
01000010010000100100000000010000010010100100001000000000000000000000000000000000000000000000000000000000000000000000000000000000
01000010010000100100000000010000010010100100001000000000000000000000000000000000000000000000000000000000000000000000000000000000
00111100010000100111111000010000001101000011110000000000000000000000000000000000000000000000000000000000000000000000000000000000
__label__
49999777499997774999977749999777499997774999977749999777499997774999977749999777499997774999977749999777499997774999977749999777
44999997449999974499999744999997449999974499999744999997449999974499999744999997449999974499999744999997449999974499999744999997
44444497444444974444449744444497444444974444449744444497444444974444449744444497444444974444449744444497444444974444449744444497
44977499449774994497749944977499449774994497749944977499449774994497749944977499449774994497749944977499449774994497749944977499
44997499449974994499749944997499449974994499749944997499449974994499749944997499449974994499749944997499449974994499749944997499
44999499449994994499949944999499449994994499949944999499449994994499949944999499449994994499949944999499449994994499949944999499
44444449444444494444444944444449444444494444444944444449444444494444444944444449444444494444444944444449444444494444444944444449
44444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444
49999777cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc49999777
44999997cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc44999997
44444497cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc44444497
44977499cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc44977499
44997499cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc44997499
44999499cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc44999499
44444449cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc44444449
44444444cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc44444444
49999777cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc49999777
44999997cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc44999997
44444497cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc44444497
44977499cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc44977499
44997499cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc44997499
44999499cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc44999499
44444449cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc44444449
44444444cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc44444444
49999777cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc49999777
44999997cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc44999997
44444497cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc44444497
44977499cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc44977499
44997499cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc44997499
44999499cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc44999499
44444449cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc44444449
44444444cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc44444444
49999777cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc49999777
44999997cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc44999997
44444497cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc44444497
44977499cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc44977499
44997499cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc44997499
44999499cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc44999499
44444449cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc44444449
44444444cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc44444444
49999777cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc49999777
44999997cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc44999997
44444497cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc44444497
44977499cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc44977499
44997499cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc44997499
44999499cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc44999499
44444449cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc44444449
44444444cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc44444444
49999777cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc49999777
44999997cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc44999997
44444497cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc44444497
44977499cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc44977499
44997499cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc44997499
44999499cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc44999499
44444449cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc44444449
44444444cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc44444444
49999777cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc49999777
44999997cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc44999997
44444497cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc44444497
44977499cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc44977499
44997499cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc44997499
44999499cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc44999499
44444449cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc44444449
44444444cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc44444444
49999777cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc49999777
44999997cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc44999997
44444497cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc44444497
44977499cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc44977499
44997499cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc222222cccccccccccccccccccccccccc44997499
44999499ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc28888882ccccccccccccccccccccccccc44999499
44444449ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc28888882ccccccccccccccccccccccccc44444449
44444444ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc28788782ccccccccccccccccccccccccc44444444
49999777cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc222222cccccccccccccccccccccccccc49999777
44999997ccccccccccccccccccccccccccc33333cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc44999997
44444497ccccccccccccccccccccccccccb3b3333ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc44444497
44977499ccccccccccccccccccccccccc33b333333cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc44977499
44997499ccccccccccccccccccccccccc33333b3b333333ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc44997499
44999499ccccccccccccccccccccccccc333333b33333333cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc44999499
44444449ccccccccccccccccccccccccc333333333333b3bcccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc44444449
44444444cccccccccccccccccccccccccc333333333333b3cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc44444444
49999777ccccccccccccccccccccccccccc3333333333333cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc49999777
44999997cccccccccccccccccccccccccccc33333b3b3333cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc44999997
44444497cccccccccccccccccccccccccc33333333b33333cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc44444497
44977499cccccccccccccccccccccccccc33b3b333333333cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc44977499
44997499cccccccccccccccccccccccccc333b333333333ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc44997499
44999499cccccccccccccccccccccccccccc33333333333ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc44999499
44444449cccccccccccccccccccccccccccccc4443333ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc44444449
44444444ccccccccccccccccccccccccccccc44444cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc44444444
49999777ccccccccccccccccccccccccccccc44444cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc49999777
44999997ccccccccccccccccccccccccccccc4554ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc87cccccccccc44999997
44444497ccccccccccccccccccccccccccccc4554cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc888cccccccccc44444497
44977499ccccccccccccccccccccccccccccc4544ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc8888cccccccccc44977499
44997499ccccccccccccccccccccccccccccc44444ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc7cccccccccc44997499
44999499ccccccccccccccccccccccccccccc44444ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc7cccccccccc44999499
44444449cccccccccccccccccccccccccccc4545454cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc7cccccccccc44444449
44444444ccccccccccccccccccccccccccc454454454ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc7cccccccccc44444444
49999777333333333333333333333333333333333333333333333333cccccccccccccccccccccccc333333333333333333333333333333333333333349999777
44999997333333333333333333333333333333333333333333333333cccccccccccccccccccccccc333333333333333333333333333333333333333344999997
44444497b3b3b33bb3b3b33bb3b3b33bb3b3b33bb3b3b33bb3b3b33bccccccccccccccccccccccccb3b3b33bb3b3b33bb3b3b33bb3b3b33bb3b3b33b44444497
44977499439b7bb9439b7bb9439b7bb9439b7bb9439b7bb9439b7bb9cccccccccccccccccccccccc439b7bb9439b7bb9439b7bb9439b7bb9439b7bb944977499
449974994b9974994b9974994b9974994b9974994b9974994b997499cccccccccccccccccccccccc4b9974994b9974994b9974994b9974994b99749944997499
44999499449994994499949944999499449994994499949944999499cccccccccccccccccccccccc449994994499949944999499449994994499949944999499
44444449444444494444444944444449444444494444444944444449cccccccccccccccccccccccc444444494444444944444449444444494444444944444449
44444444444444444444444444444444444444444444444444444444cccccccccccccccccccccccc444444444444444444444444444444444444444444444444
49999777499997774999977749999777499997774999977749999777cccccccccccccccccccccccc499997774999977749999777499997774999977749999777
44999997449999974499999744999997449999974499999744999997c1c1c1c1c1c1c1c1c1c1c1c1449999974499999744999997449999974499999744999997
44444497444444974444449744444497444444974444449744444497cccccccccccccccccccccccc444444974444449744444497444444974444449744444497
449774994497749944977499449774994497749944977499449774991c1c1c1c1c1c1c1c1c1c1c1c449774994497749944977499449774994497749944977499
44997499449974994499749944997499449974994499749944997499c1c1c1c1c1c1c1c1c1c1c1c1449974994499749944997499449974994499749944997499
44999499449994994499949944999499449994994499949944999499111111111111111111111111449994994499949944999499449994994499949944999499
44444449444444494444444944444449444444494444444944444449111111111111111111111111444444494444444944444449444444494444444944444449
44444444444444444444444444444444444444444444444444444444111111111111111111111111444444444444444444444444444444444444444444444444
49999777499997774999977749999777499997774999977749999777111111111111111111111111499997774999977749999777499997774999977749999777
44999997449999974499999744999997449999974499999744999997111111111111111111111111449999974499999744999997449999974499999744999997
44444497444444974444449744444497444444974444449744444497111111111111111111111111444444974444449744444497444444974444449744444497
44977499449774994497749944977499449774994497749944977499111111111111111111111111449774994497749944977499449774994497749944977499
44997499449974994499749944997499449974994499749944997499111111111111111111111111449974994499749944997499449974994499749944997499
44999499449994994499949944999499449994994499949944999499111111111111111111111111449994994499949944999499449994994499949944999499
44444449444444494444444944444449444444494444444944444449111111111111111111111111444444494444444944444449444444494444444944444449
44444444444444444444444444444444444444444444444444444444111111111111111111111111444444444444444444444444444444444444444444444444
49999777499997774999977749999777499997774999977749999777499997774999977749999777499997774999977749999777499997774999977749999777
44999997449999974499999744999997449999974499999744999997449999974499999744999997449999974499999744999997449999974499999744999997
44444497444444974444449744444497444444974444449744444497444444974444449744444497444444974444449744444497444444974444449744444497
44977499449774994497749944977499449774994497749944977499449774994497749944977499449774994497749944977499449774994497749944977499
44997499449974994499749944997499449974994499749944997499449974994499749944997499449974994499749944997499449974994499749944997499
44999499449994994499949944999499449994994499949944999499449994994499949944999499449994994499949944999499449994994499949944999499
44444449444444494444444944444449444444494444444944444449444444494444444944444449444444494444444944444449444444494444444944444449
44444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444

__gff__
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000303030323000001000000000000000001010180000000000000000000000000100404040400000000000000000000000a048004210000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
__map__
4040404040404040404040404040404040404040404040404040404040404040404040404040404040404040404040404040404040404040404040404040404040404040404040404040404040404040404040404040404040404040404040404040404040404040404040404040404040404040404040404040404040404040
4000004600004600000000000000004040004600000046000000004600004040400000000000460000000000004600404040404064000000460000000046004040000000460000004600000046000040400000004600000000000046000000404000000000000000000000000000000000000000000000000000000000000040
4000004600004600000000000000004040004600000046000000004600004040400000000000460000000000004600404040404064000000460000000046004040000000460000004600000046000040400000004600000000000046000000404000000000000000000000000000000000000000000000000000000000000040
4000004600004600000000000000004040004600000046000000004600004040400072000000460000000000004600404040404064000000000000000046004040000000460000000000606046000040400000004600000000000046000000404000000000000000000000000000000000000000000000000000000000000040
4000004600000000000000000072004040004600000000000000004600004040404141440000460000606060004600404040404064000000000000000046004040000000460000000060606000007240400074004600000000000000000000404000000000000000000000000000000000000000000000000000000000000040
4000004600000000000041414141414040000000000000720000004600624040404040740000000000606060004600404040404064000000000000000000004040000000460000000060600000414140400074004600000000000000000000404041414141410000000000000000000000000000000000000000000000000040
4000004600000000000074404040404040000000000041414141004600624040404040400000000000606060004600404040404064000000000000007200004040000000460000000000000000404040400074004600006100000000000000404040404040400000000000000000000000000000000000000000000000000040
4000000000000000000074404040404040000000000040404074000000624040404040406400000000606060004600404040404041410000000041414141414040000000000000000000000000404040400074000000004141410000004141404047000000000000000000000000000000000000000000000000000000000040
40000000000000000000744040404040400000000000404040740000000040404040404064000000006060600000004040404040407400000000404040404040400000000000004141000000004040404000740000000074404000000040404040000000c0c1c200000000000000000000000000000000000000000000000040
40000000000000000000744040404040400000000000404040400000000074404040404000000000006060600000004040404040407400000062404040404040400000000000007440000000004040404000000000000040404000000040404040000000d0d1d200000000000000000000000000000000000000000000000040
40000000000000000000744040404040400000000000000000000000000074404040404700000000006060600000004040404040404000000000744040404040400000000000007440717171714040404000000000000040404000000000484040000000c3c4c400000000000000000000000000000000000000000000000040
4000000000000061616140404040404040000000000000000000000000007440404047000000000000000000000000404040404040400000000074404040404040000000000000744073737373404040400000000000007440400000000000404000000000000000000000000000000000000000000000000000000000000040
4041414141414141414140404040404040000000000000000000000000004040400000000000000000000000000000404040404040400000000074404040404040000000000062404073737373404040400000000000004040400000000000404041414141000000000000414100000000000000000000000000000000000040
4040404040404040404040404040404040000000000000000000000000004040400000000000000000000000000000404040404040400000000040404040404040000000000000404073737373404040400000000000004040406161610072404040404040717171717171404000000000000000000000000000000000000040
4040404040404040404040404040404040414141414141000041414141414040400000000000616100007000000000404040404040404141414140404040404040414100000000404073737373404040400000000000007440404141414141404040404040737373737373404000000000000000000000000000000000000040
4040404040404040404040404040404040404040404040717140404040404040404141414141414141414141414141404040404040404040404040404040404040404071717171404073737373404040404141414141414040404040404040404040404040404040404040404040404040404040404040404040404040404040
4242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242
4200000000000000000000000000004242000000000000000000000000000042420000000000000000000000000000424200000000000000000000000000004242000000000000000000000000000042420000000000000000000000000000424200000000000000000000000000000000000000000000000000000000000042
4200000000000000000000000000004242000000000000000000000000000042420000000000000000000000000000424200000000000000000000000000004242000000000000000000000000000042420000000000000000000000000000424200000000000000000000000000000000000000000000000000000000000042
4200000000000000000000000000004242000000000000000000000000000042420000000000000000000000000000424200000000000000000000000000004242000000000000000000000000000042420000000000000000000000000000424200000000000000000000000000000000000000000000000000000000000042
4200000000000000000000000000004242000000000000000000000000000042420000000000000000000000000000424200000000000000000000000000004242000000000000000000000000000042420000000000000000000000000000424200000000000000000000000000000000000000000000000000000000000042
4200000000000000000000000000004242000000000000000000000000000042420000000000000000000000000000424200000000000000000000000000004242000000000000000000000000000042420000000000000000000000000000424200000000000000000000000000000000000000000000000000000000000042
4200000000000000000000000000004242000000000000000000000000000042420000000000000000000000000000424200000000000000000000000000004242000000000000000000000000000042420000000000000000000000000000424200000000000000000000000000000000000000000000000000000000000042
4200000000000000000000000000004242000000000000000000000000000042420000000000000000000000000000424200000000000000000000000000004242000000000000000000000000000042420000000000000000000000000000424200000000000000000000000000000000000000000000000000000000000042
4200000000000000000000000000004242000000000000000000000000000042420000000000000000000000000000424200000000000000000000000000004242000000000000000000000000000042420000000000000000000000000000424200000000000000000000000000000000000000000000000000000000000042
4200000000000000000000000000004242000000000000000000000000000042420000000000000000000000000000424200000000000000000000000000004242000000000000000000000000000042420000000000000000000000000000424200000000000000000000000000000000000000000000000000000000000042
4200000000000000000000000000004242000000000000000000000000000042420000000000000000000000000000424200000000000000000000000000004242000000000000000000000000000042420000000000000000000000000000424200000000000000000000000000000000000000000000000000000000000042
4200000000000000000000000000004242000000000000000000000000000042420000000000000000000000000000424200000000000000000000000000004242000000000000000000000000000042420000000000000000000000000000424200000000000000000000000000000000000000000000000000000000000042
4200000000000000000000000000004242000000000000000000000000000042420000000000000000000000000000424200000000000000000000000000004242000000000000000000000000000042420000000000000000000000000000424200000000000000000000000000000000000000000000000000000000000042
4200000000000000000000000000004242000000000000000000000000000042420000000000000000000000000000424200000000000000000000000000004242000000000000000000000000000042420000000000000000000000000000424200000000000000000000000000000000000000000000000000000000000042
4200000000000000000000000000004242000000000000000000000000000042420000000000000000000000000000424200000000000000000000000000004242000000000000000000000000000042420000000000000000000000000000424200000000000000000000000000000000000000000000000000000000000042
4242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242
__sfx__
00050000095500955009550095500d5500d5500e5500e5500e5500e5500e550061000610006100061000610016500061000610006100061000610005100135000510005100051000610006100061000610006100
0001000001500005000050000500005000050001500025000250004500055000650007500095000b5000c5000e500115001350016500185001a5001d5002150024500265002a5002f500355003d5003f5001a000
000800002000020000200002000020000200001b0001b0001b0001b0001b0001b0001b0001b000190001900019000190001900019000140001400014000140001400014000140001400015000150001500015000
000800001900019000190001900023000230002300023000210002100021000210002000020000200002000020000200001e0001e0001e0001e0001e0001e0001e0001e0001e0001e0001e0001e0001e0001e000
000800002000020000200002000020000200001b0001b0001b0001b0001b0001b0001b0001b000190001900019000190001900019000140001400014000140001400017000170001700017000150001500015000
000800001500015000150001500015000150001500015000150001500015000180001800018000180001800018000180001800018000180001800018000180001800018000180001800018000180001800018000
000800002000020000200002000020000200002100021000210002100021000230002300023000230002a0002a0002a0002a0002a0002a0002800028000280002800028000280002300023000230002300023000
0010000025000250002500025000250002500023000230002100020000200001e0001c0001b00019000190001c00019000190001c0001900019000190001900017000170001900017000190001c0002000020000
00100000210002000020000210002000020000200002000019000190001e0001c0001b000190001b0001b0001c0001e0001e000200001b0001b0001b0001b0001b0001b0001b0001b0001b0001b0001b0001b000
001000001b0001b0001b0001b0001b0001b0001b0001b0001b0001b0001b0001b0001b0001b00019000190001c00019000190001c0001900019000190001900017000170001900017000190001c0002000020000
001000001e0001e000200002300023000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001300002300023000230002300023000230002300023000200002000021000210002100020000200002000021000210002000020000200001e0001e0001e0001e00020000200002000021000210002100023000
00100000230001c0001c0001c0001c0001900019000190001b0001b0001b0001c0001c0001e0001e0001b00019000190001b00019000190001700017000170001700017000170001700017000170001700017000
00100000200002000021000210002100020000200002000021000210002000020000200001e0001e0001e0001e00020000200002000021000210002100023000230002a0002a0002a00028000280002800023000
001000002300023000230002500025000250002500025000250002500025000250002500025000250002500025000270002700027000270002700027000270002700027000270002700027000270002700027000
__music__
00 42424344
00 43424344
00 44424344
00 45444344
00 42424344
00 43424344
00 46424344
00 47424344
00 48424344
00 49424344
00 4b424344
00 4b424344
00 4c424344
00 4d424344
00 4e424344

